<?php

namespace App\Http\Controllers\API\Therapists;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Certification;
use App\Http\Requests\API\Therapists\TherapistCertifications\CreateRequest;
use App\Http\Resources\API\CertificationsResource;
use Illuminate\Support\Facades\DB;

class TherapistCertificationsController extends Controller
{
    /********* Initialize Permission based Middlewares  ***********/
  public function __construct()
  {
        $this->middleware(['api','auth:api','verified','api_setting']);
        $this->middleware('therapist.api');
      // $this->middleware('permission:therapist_certifications.index');
      // $this->middleware('permission:therapist_certifications.create',['only' => ['store']]);
      // $this->middleware('permission:therapist_certifications.update',['only' => ['update']]);
      // $this->middleware('permission:therapist_certifications.delete',['only' => ['destroy']]);
      // $this->middleware('permission:therapist_certifications.export',['only' => ['export']]);
      // $this->middleware('permission:therapist_certifications.import',['only' => ['import']])
      // $this->middleware('permission:therapist_certifications.update|therapist_certifications.is_active',['only' => ['updateStatus']]);
  }

  /********* Getter For Pagination, Searching And Sorting  ***********/
  public function getter($req = null,$export = null)
  {
    $therapist = auth()->user()->therapist;
    if($req != null){
      $therapist_certifications =  $therapist->therapist_certifications()->withAll();
      if($req->trash && $req->trash == 'with'){
        $therapist_certifications =  $therapist_certifications->withTrashed();
      }
      if($req->trash && $req->trash == 'only'){
        $therapist_certifications =  $therapist_certifications->onlyTrashed();
      }
      if($req->column && $req->column != null && $req->search != null){
          $therapist_certifications = $therapist_certifications->whereLike($req->column,$req->search);
        }
       else if($req->search && $req->search != null){

            $therapist_certifications = $therapist_certifications->whereLike(['name','description'],$req->search);
        }
      if($req->sort && $req->sort['field'] != null && $req->sort['type'] != null){
          $therapist_certifications = $therapist_certifications->OrderBy($req->sort['field'],$req->sort['type']);
      }
      else
      {
        $therapist_certifications = $therapist_certifications->OrderBy('id','desc');
      }
      if($export != null){ // for export do not paginate
        $therapist_certifications = $therapist_certifications->get();
        return $therapist_certifications;
      }
      $totalTherapistCertifications = $therapist_certifications->count();
      $therapist_certifications = $therapist_certifications->paginate($req->perPage);
      $therapist_certifications = CertificationsResource::collection($therapist_certifications)->response()->getData(true);

      return $therapist_certifications;
    }
    $therapist_certifications = CertificationsResource::collection($therapist->therapist_certifications()->withAll()->orderBy('id','desc')->paginate(10))->response()->getData(true);
    return $therapist_certifications;
  }

  /********* FETCH ALL TherapistCertifications ***********/
    public function index()
    {
        $therapist_certifications =  $this->getter();
        $response = generateResponse($therapist_certifications,count($therapist_certifications['data']) > 0 ? true:false,'TherapistCertifications Fetched Successfully',null,'collection');
        return response()->json($response, 200);
    }

  /********* FILTER TherapistCertifications FOR Search ***********/
   public function filter(Request $request){
     $therapist_certifications = $this->getter($request);
     $response = generateResponse($therapist_certifications,count($therapist_certifications['data']) > 0 ? true:false,'Filter TherapistCertifications Successfully',null,'collection');
     return response()->json($response, 200);
   }

    /********* ADD NEW TherapistCertification ***********/
    public function store(CreateRequest $request)
    {
      $therapist = auth()->user()->therapist;
      try{
      DB::beginTransaction();
      $request->merge(['created_by_user_id'=>auth()->user()->id]);
      $data = $request->all();
      $data['image'] = uploadFile($request,'file','therapist_certifications');
      $therapist_certification = $therapist->therapist_certifications()->create($data);
      DB::commit();
      $therapist_certification = $therapist->therapist_certifications()->withAll()->find($therapist_certification->id);
      $therapist_certification = new CertificationsResource($therapist_certification);
      $response = generateResponse($therapist_certification,true ,'TherapistCertifications Created Successfully',null,'collection');
      return response()->json($response, 200);
    }
      catch (\Exception $e) {
        DB::rollBack();
        $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
        return response()->json($response, 200);
     }
    }

    /********* View RECORD TO EDIT Or Display ***********/
    public function show(Certification $therapist_certification)
    {
        $therapist = auth()->user()->therapist;
        if($therapist_certification->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
        $therapist_certification = $therapist->therapist_certifications()->withAll()->find($therapist_certification->id);
        if($therapist_certification){
          $therapist_certification = new CertificationsResource($therapist_certification);
          $response = generateResponse($therapist_certification,true,'TherapistCertification Fetched Successfully',null,'object');
        }
        else{
          $response = generateResponse(null,false,'TherapistCertification Not Found',null,'object');
        }
        return response()->json($response, 200);
    }

    /********* UPDATE TherapistCertification ***********/
    public function update(CreateRequest $request, Certification $therapist_certification)
    {
        // dd($request->all());
        $therapist = auth()->user()->therapist;
        if($therapist_certification->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
      try{
        DB::beginTransaction();
        $request->merge(['last_updated_by_user_id'=>auth()->user()->id]);
        $data = $request->all();
        if ($request->file) {
            $data['image'] = uploadFile($request,'file','therapist_certifications',$therapist_certification->image);
        } else {
            $data['image'] = $therapist_certification->image;
        }
        $therapist_certification->update($data);
        DB::commit();
        $therapist_certification = $therapist->therapist_certifications()->withAll()->find($therapist_certification->id);
        $therapist_certification = new CertificationsResource($therapist_certification);
        $response = generateResponse($therapist_certification,true,'TherapistCertification Updated Successfully',null,'object');
        return response()->json($response, 200);
      }
        catch (\Exception $e) {
          DB::rollBack();
          $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
          return response()->json($response, 200);
       }
    }

    /********* UPDATE TherapistCertification Status***********/
    public function updateStatus(Request $request,Certification $therapist_certification){
      try{
        $therapist = auth()->user()->therapist;
        if($therapist_certification->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
        $therapist_certification->update([
          'is_active' => $therapist_certification->is_active == 1 ? 0:1
        ]);
        $response = generateResponse(null,true,'TherapistCertification Status Updated Successfully',null,'object');
        return response()->json($response, 200);
      }
      catch (\Exception $e) {
        DB::rollBack();
        $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
        return response()->json($response, 200);
     }
    }


    /********* DELETE TherapistCertification ***********/
    public function destroy(Request $request,Certification $therapist_certification)
    {
      try{
        $therapist = auth()->user()->therapist;
        if($therapist_certification->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
          if($therapist_certification->trashed()) {
            $response = generateResponse(null,false ,'Already in Trash',null,'collection');
            return response()->json($response, 404);
          }
          else{
            $therapist_certification->delete();
          }
          $response = generateResponse(null,true,'TherapistCertification Deleted Successfully',null,'object');
          return response()->json($response, 200);

        } catch (\Exception $e) {
          DB::rollBack();
          $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
          return response()->json($response, 200);
       }
    }
    /*********Permanently DELETE TherapistCertification ***********/
    public function destroyPermanently(Request $request,$therapist_certification)
    {
      try{
        $therapist= auth()->user()->therapist;
        $therapist_certification = $therapist->therapist_certifications()->withTrashed()->find($therapist_certification);
        if($therapist_certification){
            if($therapist_certification->therapist_id != $therapist->id){
              $response = generateResponse(null,false ,'Not Found',null,'collection');
              return response()->json($response, 404);
            }
          if ($therapist_certification->trashed()) {
            $therapist_certification->forceDelete();
            $response = generateResponse(null,true,'TherapistCertification Deleted Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistCertification is not in trash to delete permanently',null,'object');
          }
        }
        else{
          $response = generateResponse(null,false,'TherapistCertification not found',null,'object');
        }
          return response()->json($response, 200);

        } catch (\Exception $e) {
          DB::rollBack();
          $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
          return response()->json($response, 200);
       }
    }
    /********* Restore TherapistCertification ***********/
    public function restore(Request $request,$therapist_certification)
    {
      $therapist= auth()->user()->therapist;
      $therapist_certification = $therapist->therapist_certifications()->withTrashed()->find($therapist_certification);
          if ($therapist_certification->trashed()) {
            $therapist_certification->restore();
            $response = generateResponse(null,true,'TherapistCertification Restored Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'TherapistCertification is not trashed',null,'object');
          }
          return response()->json($response, 200);
    }
}
